package compositePakage;

public abstract class Component 
{

// la classe Component implementa sia l'interfaccia di Leaf che di Composite

  public Component(String aName)
  	{
  	name = aName;
  	}
 
  
  //attributo pubblico per semplificare il codice
  public String name;
  
  // questa  l'operazione, che il Leaf implementer direttamente
  // mentre il Composite delegher ai suoi componenti
  public abstract void printName();

  // questa  l'interfaccia di gestione dei figli.
  //  stato implementato un controllo per evitare che i Leaf 
  // tentino di aggiungere o rimuovere figli.
  // --> si privilegia la sicurezza!
  public void add(Component c) throws LeafException
  	{
  	if (this instanceof LeafInterface)
  		{
    	throw new LeafException("Impossibile aggiungere componenti a un Leaf!");
  		}
  	}

  public void remove(Component c) throws LeafException
  	{
  	if (this instanceof LeafInterface)
  		{
    	throw new LeafException("Impossibile cancellare componenti a un Leaf!");
  		}
  	}
 
  // Comunque anche getChild() potrebbe sollevare un'eccezione...

  public Component getChild(int n)
  	{
  	return null;
  	}

}